/*
 * Copyright (c) 2010 Lenka Trochtova
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup libdrv
 * @{
 */
/** @file
 */

#ifndef DDF_INTERRUPT_H_
#define DDF_INTERRUPT_H_

#include <kernel/ddi/irq.h>
#include <adt/list.h>
#include <ddi.h>
#include <fibril_synch.h>

#include "driver.h"
#include "../dev_iface.h"

/*
 * Interrupts
 */

typedef void interrupt_handler_t(ddf_dev_t *, ipc_callid_t, ipc_call_t *);

typedef struct interrupt_context {
	int id;
	ddf_dev_t *dev;
	int irq;
	interrupt_handler_t *handler;
	link_t link;
} interrupt_context_t;

typedef struct interrupt_context_list {
	int curr_id;
	link_t contexts;
	fibril_mutex_t mutex;
} interrupt_context_list_t;

extern interrupt_context_t *create_interrupt_context(void);
extern void delete_interrupt_context(interrupt_context_t *);
extern void init_interrupt_context_list(interrupt_context_list_t *);
extern void add_interrupt_context(interrupt_context_list_t *,
    interrupt_context_t *);
extern void remove_interrupt_context(interrupt_context_list_t *,
    interrupt_context_t *);
extern interrupt_context_t *find_interrupt_context_by_id(
    interrupt_context_list_t *, int);
extern interrupt_context_t *find_interrupt_context(
    interrupt_context_list_t *, ddf_dev_t *, int);

extern int register_interrupt_handler(ddf_dev_t *, int, interrupt_handler_t *,
    irq_code_t *);
extern int unregister_interrupt_handler(ddf_dev_t *, int);

#endif

/**
 * @}
 */
