/*
 * Copyright (c) 2006 Ondrej Palkovsky
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - The name of the author may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/** @addtogroup libcia64
 * @{
 */
/** @file
 */

#ifndef LIBC_ia64_TYPES_H_
#define LIBC_ia64_TYPES_H_

#define __64_BITS__

#include <libarch/common.h>

#define SIZE_MIN  UINT64_MIN
#define SIZE_MAX  UINT64_MAX

#define SSIZE_MIN  INT64_MIN
#define SSIZE_MAX  INT64_MAX

typedef struct {
	uint64_t lo;
	int64_t hi;
} __attribute__((aligned(16))) int128_t;

typedef struct {
	uint64_t lo;
	uint64_t hi;
} __attribute__((aligned(16))) uint128_t;

typedef uint64_t sysarg_t;
typedef int64_t native_t;

typedef int64_t ssize_t;
typedef uint64_t size_t;

typedef uint64_t uintptr_t;
typedef int64_t intptr_t;
typedef uint64_t atomic_count_t;
typedef int64_t atomic_signed_t;

typedef struct {
	uintptr_t fnc;
	uintptr_t gp;
} __attribute__((may_alias)) fncptr_t;

#endif

/** @}
 */
